﻿####	DRIFT SKILLS
####	============

####	For Lapper V5.926 and later (may work with earlier versions)

####	idea by Ingolf
####	original basic coding by Sinanju
####	Thanks to Krayy for database help and advice, and Dygear and Austin Hedley for other help
          
############################################################################################################################################################################
#### 	Ver 0.1 - 24 Oct 2010 - Initial release with problems in database function, unable to convert laptimes into numbers and !dskills table not showing any results	####
####	Ver 0.2 - 25 Oct 2010 - Now converted laptime into number and changed button layout slightly - still some issues with database					####
####	Ver 0.3 - 28 Oct 2010 - Button layout changes, now testing single drift skill formula [ ((driftscore / laptime) / 16.667) ] 					####
####	Ver 0.4 - 03 Nov 2010 - Changes to setting and retrieving database variables                                                 					####
####	Ver 0.4c - 03 Nov 2010 - Simple button scoreboard			                                                 					####
############################################################################################################################################################################
####                                            ####									####						####
####	INFO					####	SCORING								####	ISSUES					####
####	===============================		####	========================================================	####	======================================= ####
####						####				                  	       		####						####
####	Add the following line into the		####	Although you may display driftpoints when drifting		####	Unable to output skills into any 	####
####	/addonsused.lpr file			####	on an outlap and an inlap, you will only score driftpoints	####	kind of TopUsers table.			####
####						####	and skillpoints on completion of a full lap (or circuit).	####						####
####	include( "./dskill.lpr");		####									####						####
####						####	Points are reset to zero when lap completed, although    	####	As yet, untested in km/h mode		####
####						####	this may not show until scores overwritten.			####						####
####						####									####						####
####	Skill Points based on                   ####	If your speed falls below minimum allowed speed, or		####						####
####						####	drift angle is above or below allowed angle, then all		####						####
####	10,000 drift points per minute          ####	scores will be lost, although this may not show until		####	Only an English language file		####
####						####	scores overwritten.						####						####
####						####								 	####						####
############################################################################################################################################################################



CatchEvent OnLap( $userName ) # Player event

  	$Username = GetCurrentPlayerVar( "Username" );
 
  $MinimumDriftSpeed = 39; # Minimum speed in km/h to maintain. Driving below that speed will reset score
  $MinimumDriftAngle = 5; # Minimum angel to maintain. When angle is below value, score is reset
  $MaximumDriftAngle = 75; # Maximum angel to maintain. When angle is above value, score is reset
  $GoodDriftScore = 2500; # Value to be reached to execute action on good drift score
  $MinimumDriftScore = 100; # Minimum drift score required

	$NickName = GetCurrentPlayerVar("NickName");
	$car = GetCurrentPlayerVar("Car");
	$track = getLapperVar("ShortTrackName");

### Catch Event Variables

	$lap_time_time = NumToMSH(GetCurrentPlayerVar( "LapTime" ));
	$lap_time_number = (MSHToNum($lap_time_time)/1000);
	$drift_score = GetCurrentPlayerVar( "DriftScore" );
	$drift_skill = round((($drift_score/$lap_time_number)/16.667),2);

### Set button and initial left/right and top/bottom coordinates ###
	$origL = 165;		# Left edge of button
	$origT = 130;		# Top edge of button
	$Width = 15;		# width of button
	$Height = 4;		# height of button
	$spacing = 4;		# text spacing
	$time = 10;		# display button for how many seconds (-1 = permanent)

####  SIMPLE SCOREBOARD

	openPrivButton( "ds_back",$origL,$origT,$Width+15,$Height+36,$spacing,$time,32," ");
	openPrivButton( "ds_bck2",$origL,$origT,$Width+15,$Height+36,$spacing,$time,32," ");
	openPrivButton( "ds_sbox",$origL+4,$origT+15,$Width+7,$Height+15,$spacing,$time,16," "); # box for score to sit in
	openPrivButton( "ds_box2",$origL+4,$origT+15,$Width+7,$Height+15,$spacing,$time,16," "); # box for score to sit in
	openPrivButton( "ds_dssl",$origL+2,$origT+4,$Width+11,$Height+6,$spacing,$time,0,"Drift Skill");	

	openPrivButton( "ds_dssr",$origL+4,$origT+12,$Width+7,$Height+21,$spacing,$time,0,langEngine("%{main_ds_dssr}%", $drift_skill)); # Drift Skill Score Result


####	Global sms Message sent to everyone on completion of full lap by any player

	globalMsg( langEngine( "%{main_ds_msg}%",$NickName,$drift_skill )); # sms message

 ####	####	####	Save value to stored values if drift skill is higher than previous		####	####	####


 IF ( $drift_skill > GetStoredValue($userName . ",DriftSkill," . $track . "," . $car))
  
    THEN

	privMsg( langEngine( "%{main_ds_better}%",$NickName));

	SetStoredValue( $userName . ",DriftSkill," . $track . "," . $car, $drift_skill);

  	ELSE
	
	privMsg( langEngine( "%{main_ds_worse}%",$NickName));
	
  ENDIF 
    
EndCatchEvent


LANG "EN"

main_ds_msg = "{0} ^2has a Drift Skill Score of ^1{1}"; # where {0} = driver, and {1} = drift skill score
main_ds_better = "^2Congrats: your ^1best ^2Drift Skill score with this combo";
main_ds_worse = "^1Sorry: ^3not your best Drift Skill score in this combo";
main_ds_dssr = "^1{0}";

EndLang